/*:
 * @plugindesc 移動先スプライト表示を変更します
 * @author hara
 *
 * @help
 * 移動先スプライト(白くて四角くくてチカチカするやつ)の表示を変更します。
 * ・形を四角から丸にします。
 * ・拡大アニメーションに緩急をつけます。
 * ・表示終了をアニメーションのキリの良い所にします。
 * 
 * ・利用規約
 * 禁止事項はありません。
 */

(function() {
'use strict';

var _Sprite_Destination_createBitmap = Sprite_Destination.prototype.createBitmap;
Sprite_Destination.prototype.createBitmap = function() {
    _Sprite_Destination_createBitmap.call(this);
    var width = $gameMap.tileWidth() * 2;
    var height = width;
    var rad = width / 2;
    this.bitmap = new Bitmap(width, height);        // bitmapを上書きして変更
    this.bitmap.drawCircle(rad, rad, rad, 'white');
};

Sprite_Destination.prototype.update = function() {
    Sprite.prototype.update.call(this);
    if ($gameTemp.isDestinationValid()){
        this.updatePosition();
        this.updateAnimation();
        this.visible = true;
    } else {
        this.stopAnimation();
    }
};

Sprite_Destination.prototype.updateAnimation = function() {
    this._frameCount++;
    this._frameCount %= 60;
    this.opacity = (60 - this._frameCount) * 3;
    var nowScale = this._frameCount / 60;
    this.scale.x = nowScale;
    this.scale.y = nowScale;
    if (nowScale < 0.7) this._frameCount += 4;
};

Sprite_Destination.prototype.stopAnimation = function() {
    if (this._frameCount == 59 || this._frameCount == 0){
        this._frameCount = 0;
        this.visible = false;
    } else {
        this.updateAnimation();
    }
};

})();